<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(isRtl() ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($restaurant->name ?? 'Demo Restaurant'); ?> - <?php echo app('translator')->get('modules.order.kotTicket'); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Arial', sans-serif;
        }
        [dir="rtl"] { text-align: right; }
        [dir="ltr"] { text-align: left; }
        .receipt {
            width: 80mm;
            padding: 6.35mm;
            page-break-after: always;
        }
        .header {
            text-align: center;
            margin-bottom: 3mm;
        }
        .bold {
            font-weight: bold;
        }
        .restaurant-name {
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 1mm;
        }
        .restaurant-info {
            font-size: 11pt;
            margin-bottom: 1mm;
        }
        .order-info {
            text-align: center;
            border-top: 1px dashed #000;
            border-bottom: 1px dashed #000;
            padding: 2mm 0;
            margin-bottom: 3mm;
            font-size: 11pt;
        }
        .kot-title {
            font-size: 14pt;
            font-weight: bold;
            text-align: center;
            margin-bottom: 2mm;
        }
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 3mm;
            font-size: 11pt;
        }
        .items-table th {
            padding: 1mm;
            border-bottom: 1px solid #000;
        }
        [dir="rtl"] .items-table th { text-align: right; }
        [dir="ltr"] .items-table th { text-align: left; }
        .items-table td {
            padding: 1mm 0;
            vertical-align: top;
        }
        .qty {
            width: 15%;
            text-align: center;
        }
        .description {
            width: 85%;
        }
        .modifiers {
            font-size: 10pt;
            color: #555;
        }
        .footer {
            text-align: center;
            margin-top: 3mm;
            font-size: 11pt;
            padding-top: 2mm;
            border-top: 1px dashed #000;
        }
        .italic {
            font-style: italic;
        }
        @media print {
            @page {
                margin: 0;
                size: 80mm auto;
            }
        }
    </style>
</head>
<body>
    <div class="receipt">
        <div class="header">
            <div class="restaurant-name">
             
                <span><?php echo e(restaurant()->name); ?></span>
                
            </div>
            <div class="restaurant-info"><?php echo e(branch()->name); ?></div>
            <div class="restaurant-info"><?php echo branch()->address; ?></div><br>
            <div class="restaurant-info" >
                    <?php if($kot->order->waiter && $kot->order->waiter->name): ?>
                        <span style="margin-left:-5px"><?php echo app('translator')->get('modules.order.waiter'); ?> :<span class=""><?php echo e($kot->order->waiter->name); ?></span></span>
                    <?php endif; ?>
                    <?php if( $kot->order->number_of_pax): ?>
                        <span style="margin-left:70px"><?php echo app('translator')->get('modules.order.noOfPax'); ?> :<span class=""><?php echo e($kot->order->number_of_pax); ?></span></span>
                    <?php endif; ?>
                </div>
            <!--<?php if(isset($kotPlace) && $kotPlace): ?>-->
            <!--    <div class="restaurant-info"><?php echo e($kotPlace->name); ?></div>-->
            <!--<?php endif; ?>-->
        </div>
        <!--<div class="kot-title">-->
        <!--    <?php echo app('translator')->get('modules.order.kitchenOrderTicket'); ?>-->
        <!--</div>-->
        <div class="order-info" style="display: flex; justify-content: space-between; align-items: flex-start;">
            <div style="text-align: left;">
                <div>
                    <?php echo app('translator')->get('modules.order.orderNumber'); ?> <span class="bold">#<?php echo e($kot->order->order_number); ?></span>
                    
                </div>
                <div style="margin-top: 5px;margin-left:-5px">
                    <?php if($kot->order->table): ?>
                        <span style="margin-left: 5px;"><?php echo app('translator')->get('modules.table.table'); ?> - <span class="bold"><?php echo e($kot->order->table->table_code); ?></span></span>
                    <?php endif; ?>
                </div>
                <div style="margin-top: 5px;">
                    <?php echo app('translator')->get('app.date'); ?>: <?php echo e($kot->created_at->timezone($kot->branch->restaurant->timezone)->format('d-m-Y')); ?>

                </div>
            </div>
            <div style="text-align: right;">
                <div>
                    KOT <span class="bold">#<?php echo e($kot->id); ?></span>
                </div>
                <div style="margin-top: 5px;">
                    <?php echo app('translator')->get('app.time'); ?>: <?php echo e($kot->created_at->timezone($kot->branch->restaurant->timezone)->format('h:i A')); ?>

                </div>
            </div>
        </div>
        <table class="items-table">
            <thead>
                <tr>
                    <th class="description"><?php echo app('translator')->get('modules.menu.itemName'); ?></th>
                    <th class="qty"><?php echo app('translator')->get('modules.order.qty'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $items = isset($kotPlaceId)
                        ? $kot->items->filter(function($item) use($kotPlaceId) {
                            return $item->menuItem && $item->menuItem->kot_place_id == $kotPlaceId;
                        })
                        : $kot->items;
                ?>
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="description">
                            <?php echo e($item->menuItem->item_name); ?>

                            <?php if(isset($item->menuItemVariation)): ?>
                                <br><p class="italic" style="font-size: 10pt">(<?php echo e($item->menuItemVariation->variation); ?>)</p>
                            <?php endif; ?>
                            <?php $__currentLoopData = $item->modifierOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modifier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="modifiers">• <?php echo e($modifier->name); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->note): ?>
                                <div class="modifiers"><strong><?php echo app('translator')->get('modules.order.note'); ?>:</strong> <?php echo e($item->note); ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="qty"><?php echo e($item->quantity); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php if($kot->note): ?>
            <div class="footer">
                <strong><?php echo app('translator')->get('modules.order.specialInstructions'); ?>:</strong>
                <div class="italic"><?php echo e($kot->note); ?></div>
            </div>
        <?php endif; ?>
    </div>
    <script>
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>
<?php /**PATH /home/inaa2962/public_html/pos.inarebali.com/resources/views/pos/printKot.blade.php ENDPATH**/ ?>